#include <xtl.h>
#include <xgraphics.h>
#include <stdio.h>
#include "XBUtil.h"
#include "XBResource.h"
#include "XBResourceEx.h"
#include "httpd-filehdlr.h"

extern "C" unsigned char *filedata;

//-----------------------------------------------------------------------------
// Name: Create()
// Desc: Loads all the texture resources from the given XPR.
//-----------------------------------------------------------------------------
HRESULT CXBPackedResourceEx::CreateFromEFS( const CHAR* strFilename, DWORD dwNumResourceTags,
                                   XBRESOURCE* pResourceTags )
{
    BOOL bHasResourceOffsetsTable = FALSE;

    // Open the file
    struct fileHdrStruct file;
    DWORD dwNumBytesRead;
    if(!lookupFilename((char *)strFilename, &file))
    {
        OutputDebugString( "CXBPackedResource::CreateFromEFS(): ERROR: File not found!\n" );
        return E_FAIL;
    }
	unsigned char *fdata = filedata + file.fileStart;
    unsigned long fsize=file.size;
    // Read in and verify the XPR magic header
    XPR_HEADER xprh;

    dwNumBytesRead=min(sizeof(XPR_HEADER), fsize);
	memcpy(&xprh, fdata, dwNumBytesRead);
	fdata+=dwNumBytesRead;
	fsize-=dwNumBytesRead;

//-----------------------------------------------------------------------------
// Magic values to identify XPR files
//-----------------------------------------------------------------------------
#define XPR0_MAGIC_VALUE 0x30525058
#define XPR1_MAGIC_VALUE 0x31525058

	if( xprh.dwMagic == XPR0_MAGIC_VALUE )
    {
        bHasResourceOffsetsTable = FALSE;
    }
    else if( xprh.dwMagic == XPR1_MAGIC_VALUE )
    {
        bHasResourceOffsetsTable = TRUE;
    }
    else
    {
        OUTPUT_DEBUG_STRING( "Invalid Xbox Packed Resource (.xpr) file" );
        return E_INVALIDARG;
    }

    // Compute memory requirements
    m_dwSysMemDataSize = xprh.dwHeaderSize - sizeof(XPR_HEADER);
    m_dwVidMemDataSize = xprh.dwTotalSize - xprh.dwHeaderSize;

    // Allocate memory
    m_pSysMemData = new BYTE[m_dwSysMemDataSize];
    m_pVidMemData = (BYTE*)D3D_AllocContiguousMemory( m_dwVidMemDataSize, D3DTEXTURE_ALIGNMENT );

    // Read in the data from the file
    dwNumBytesRead=min(m_dwSysMemDataSize, fsize);
	memcpy(m_pSysMemData, fdata, dwNumBytesRead);
	fdata+=dwNumBytesRead;
	fsize-=dwNumBytesRead;
    dwNumBytesRead=min(m_dwVidMemDataSize, fsize);
	memcpy(m_pVidMemData, fdata, dwNumBytesRead);
	fdata+=dwNumBytesRead;
	fsize-=dwNumBytesRead;

    // Extract resource table from the header data
    if( bHasResourceOffsetsTable )
    {
        m_dwNumResourceTags = *(DWORD*)(m_pSysMemData+0);
        m_pResourceTags     = (XBRESOURCE*)(m_pSysMemData+4);

        // Patch up the resource strings
        for( DWORD i=0; i<m_dwNumResourceTags; i++ )
            m_pResourceTags[i].strName = (CHAR*)( m_pSysMemData + (DWORD)m_pResourceTags[i].strName );
    }

    // Use user-supplied number of resources and the resource tags
    if( dwNumResourceTags !=0 || pResourceTags != NULL )
    {
        m_pResourceTags     = pResourceTags;
        m_dwNumResourceTags = dwNumResourceTags;
    }

    return S_OK;
}


